clear;

clc;


load Data  % RV series of daily RV JPM from 2004 to 2007 computed with 5 minutes and 5 seconds grids.

freq=[1,5,22]; % lags in the HAR model of Corsi

T=size(RV_5_min,1);

%% Auxiliary estimation

result1=HAR(log(RV_5_sec),[],freq,1);
result2=HAR(log(RV_5_min),[],freq,1);
   
% Now I construct the weighting matrix%$
Omega=cov([result1.resid,result2.resid]);
    
beta_hat=[result1.beta;result2.beta;vechmd(Omega)];
Sigma1=result1.V;
Sigma2=result2.V;
Sigma3=2*result1.sige^2/T;
Sigma4=2*result1.sige*result2.sige/T;
Sigma5=2*result2.sige^2/T;
Sigma=blkdiag(Sigma1,Sigma2,Sigma3,Sigma4,Sigma5);
invVCV=inv(Sigma);

%% Setup of II

M=4680; % number of 5 second intervals in a day

H=100; % we are generating big matrices here. On the server, we use H=100.

D=12*5; % sampling frequency at 5 minutes (12*5*5 seconds)

my_optim = optimset('Display','iter', 'Algorithm','interior-point','TolFun',...
    10^-5,'TolX',10^-5,'DiffMin',10^-4,'MaxFunEvals', 800);

theta0=[  2.9383    0.0374    0.4587    1.9138    0.1727    0.0001 0]'; % starting values
    
 LB=[eps,eps,eps,eps,eps,eps,-1]; % boundaries on the coefficients
 UB=[100,10,100,10,10,10,1];
    
    
    randn('seed',1020);
    W=randn(T*M,5,H);  % big array with the innovations


 
 %% II Estimation 
   [theta_hat,chi2_hat_0,ex0]=fminsearchbnd('II_2FHeston_MA_noise',theta0,LB,UB,my_optim,beta_hat,M,T,H,invVCV,W);
 
 %% Computation of the covariance matrix of the parameters  
     
    db=gradp('Binding_2FHeston_MA_noise',theta_hat,beta_hat,M,T,H,W); % Compute the Jacbian
     
     VCV=(1+1/H)*inv(db'*invVCV*db)/T; % Variance matrix of theta_hat
     
     SE=sqrt(diag(VCV));  % Standard errors of theta_hat 
    